/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock.test;

import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.clock.test.WorkerThread;
import java.util.Observable;
import java.util.Observer;

public class TestClock {
    static final int[] inc_values = new int[]{1, 2, 3, 5, 23};
    private long clock_speed = 0L;

    public static void main(String[] args) {
        TestClock test = new TestClock();
        try {
            test.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run() throws Exception {
        ClockImplementation clock = new ClockImplementation();
        clock.addClockSpeedObserver(new ClockSpeedObserver());
        WorkerThread[] threads = new WorkerThread[inc_values.length];
        int i = 0;
        while (i < inc_values.length) {
            threads[i] = new WorkerThread(clock, inc_values[i]);
            threads[i].start();
            ++i;
        }
        System.out.println(String.valueOf(inc_values.length) + " threads counting...");
        this.waitForClockSpeed();
        WorkerThread.stopThread();
        System.out.println("clock speed = " + this.clock_speed);
        i = 0;
        while (i < inc_values.length) {
            threads[i].interrupt();
            ++i;
        }
    }

    public synchronized void waitForClockSpeed() throws InterruptedException {
        this.clock_speed = 0L;
        while (this.clock_speed == 0L) {
            this.wait();
        }
    }

    public synchronized void notifyClockSpeed(long clock_speed) {
        this.clock_speed = clock_speed;
        this.notifyAll();
    }

    class ClockSpeedObserver
    implements Observer {
        ClockSpeedObserver() {
        }

        @Override
        public void update(Observable arg0, Object clock_speed) {
            TestClock.this.notifyClockSpeed((Long)clock_speed);
        }
    }
}

